/* ***************************************************************************+
 * ITX package (cnrg.itx) for telephony application programming.              *
 * Copyright (c) 1999  Cornell University, Ithaca NY                          *
 *                                                                            *
 * This program is free software; you can redistribute it and/or modify       *
 * it under the terms of the GNU General Public Liense as published by        *
 * the Free Software Foundation, either version 2 of the License, or (at      * 
 * your option) any later version.                                            *
 *                                                                            *
 * The ITX package is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY, without even the implied warranty of MERCHANTABILITY *
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License   *
 * for more details.                                                          * 
 *                                                                            *
 * A copy of the license is distributed with this package.  Look in the docs  *
 * directory, filename GPL.                                                   *
 *                                                                            * 
 * Contact information:                                                       *
 * Donna Bergmark                                                             *
 * 484 Rhodes Hall                                                            *
 * Cornell University                                                         *
 * Ithaca, NY 14853-3801                                                      *
 * bergmark@cs.cornell.edu                                                    *
 ******************************************************************************/


package cnrg.itx.datax.client;

import cnrg.itx.datax.*;
import cnrg.itx.datax.devices.*;
import java.util.*;
import java.net.*;
import java.io.*;

/**
 * Usage: jview cnrg.itx.datax.client.FullTest <Address to talk to>
 * 
 * Establishes a connection with another DataX unit using the default audioConnection
 * Tests audioConnection functionality and the dual jaudio playback.
 * 
 * @author Naveen Sastry
 * @version 1.1, 3/6/1999
 * @see cnrg.itx.datax.Channel
 * @see cnrg.itx.datax.devices.StreamSource
 * @see cnrg.itx.datax.devices.NetworkDestination
 * @see cnrg.itx.datax.devices.NetworkSource
 * @see cnrg.itx.datax.devices.SpeakerDestination
 */
class FullTest implements Observer
{	
	public static void main(String []args) throws Exception
	{	
		BufferedReader br = new BufferedReader( new InputStreamReader( System.in) ) ;
		if (args.length == 0)
		{
			System.out.println("usage: cnrg.itx.datax.client.FullTest <peer name> [input|output]");
			System.exit(0);
		}
		try
		{
			int iDataSize = 0;
			AudioConnection ac = null;
			if (args.length > 1)
			{
				Channel cInput = null, cOutput = null;
				if (args[1].equals("input"))
				{
				   cInput = new Channel();
				   cInput.setSource(new MicrophoneSource(cInput));
				   //cInput.setSource ( new StreamSource(null, cInput, 64));
				   cInput.addDestination(new NetworkDestination());
				}
				if (args[1].equals("output"))
				{
				   cOutput = new Channel();
				   cOutput.setSource(new NetworkSource(cOutput, MicrophoneSource.SAMPLE_SIZE ));
				   cOutput.addDestination(new SpeakerDestination());
				   //cOutput.addDestination(new StreamDestination(new FileOutputStream("blah.wav")));
				}
				ac = new AudioConnection(cInput, cOutput);
			}
			else
			{
				ac = AudioConnection.getDefaultAudioConnection();
			}
			//PropertiesCollection pc = ac.getInputChannel().getSource().getProperties();
			PropertiesCollection pc = ac.getProperties();
			for (Enumeration e = pc.getProperties(); e.hasMoreElements() ; )
			{
				Property p = (Property)e.nextElement();
				if (p instanceof NetworkProperty)
				{
					System.out.println("I am listening on port: " + ((NetworkProperty)p).getPort());
					System.out.println("My initial sequence number is: " + ((NetworkProperty)p).getInitialSequenceNumber());
					iDataSize = ((NetworkProperty)p).getPacketSize();
				}
			}
			
			String s;
			System.out.println("Enter other computer's data port: " );
			s = br.readLine();
			int iPort = Integer.parseInt(s);
			
			System.out.println("Enter other computer's sequence number: " );
			s = br.readLine();
			int iSeqNo = Integer.parseInt(s);
			
			InetAddress iaOtherGuy = InetAddress.getByName(args[0]);

			pc = new PropertiesCollection();
			pc.addProperty( new NetworkProperty(iPort, iaOtherGuy ,iDataSize, 0, iSeqNo) );
			//pc.addProperty( new NetworkProperty(5000, iaOtherGuy ,iDataSize, 0, iSeqNo) );
			
			ac.setPeerProperties(pc);
			System.out.println("Press enter to begin data transmission...");
			br.readLine();
			ac.open();
			ac.addObserver (new FullTest() );
			
		}
		catch (Exception e)
		{
			System.out.println(e.getMessage());
		}
		System.in.read();
	}

   public void update(Observable o, Object arg)
   {
      //System.out.println( ((Stats)arg).toString() );
   }

}
